#!/usr/bin/python3

import warnings
warnings.filterwarnings("ignore", message="pkg_resources is deprecated as an API")

import cv2
import face_recognition

# Load and process first image
img1 = cv2.imread("t2.jpg")
if img1 is None:
    print("Content-Type: text/html\n")
    print("<p>Error: Could not load t2.jpg</p>")
    exit()

rgb_img1 = cv2.cvtColor(img1, cv2.COLOR_BGR2RGB)
encodings1 = face_recognition.face_encodings(rgb_img1)
if len(encodings1) == 0:
    print("Content-Type: text/html\n")
    print("<p>No face found in t2.jpg</p>")
    exit()
img_encoding1 = encodings1[0]

# Load and process second image
img2 = cv2.imread("t3.png")
if img2 is None:
    print("Content-Type: text/html\n")
    print("<p>Error: Could not load t3.png</p>")
    exit()

rgb_img2 = cv2.cvtColor(img2, cv2.COLOR_BGR2RGB)
encodings2 = face_recognition.face_encodings(rgb_img2)
if len(encodings2) == 0:
    print("Content-Type: text/html\n")
    print("<p>No face found in A1.jpg</p>")
    exit()
img_encoding2 = encodings2[0]

# Compare faces
result = face_recognition.compare_faces([img_encoding1], img_encoding2)

# Output as HTML
print("Content-Type: text/html\n")
print(f"<p>Match result: {result}</p>")
